<?php
// +------------------------------------------------------------------------+
// | @author Deen Doughouz (DoughouzForest)
// | @author_url 1: http://www.playtubescript.com
// | @author_url 2: http://codecanyon.net/user/doughouzforest
// | @author_email: wowondersocial@gmail.com   
// +------------------------------------------------------------------------+
// | PlayTube - The Ultimate Video Sharing Platform
// | Copyright (c) 2017 PlayTube. All rights reserved.
// +------------------------------------------------------------------------+


  

if (empty($_GET['video_id'])) {
	$response_data       = array(
        'api_status'     => '400',
        'api_version'    => $api_version,
        'errors'         => array(
            'error_id'   => '1',
            'error_text' => 'Bad Request, Invalid or missing parameter'
        )
    );
}

else{

	$video_id = PT_Secure($_GET['video_id']);
	$video    = $db->where('video_id',$video_id)->getOne(T_VIDEOS,array('video_id','user_id'));

	if (empty($video)) {
		$response_data       = array(
	        'api_status'     => '404',
	        'api_version'    => $api_version,
	        'errors'         => array(
	            'error_id'   => '2',
	            'error_text' => 'Video does not exist'
	        )
	    );
	}


	else{

		$video_data = PT_GetVideoByID($video->video_id,0,1);

		if (!empty($video_data)) {
			$t_videos                     = T_VIDEOS;
			$video_data->is_subscribed    = 0;
			$video_data->suggested_videos = array();
			$video_data->owner            = array_intersect_key(
				ToArray($video_data->owner), 
				array_flip($user_public_data)
			);

			if (IS_LOGGED && $video_data->user_id != $user->id) {
				$db->where('subscriber_id',$user->id);
				$db->where('user_id',$video_data->user_id);
				$db->where('active',1);
				$subscribed = ($db->getValue(T_SUBSCRIPTIONS,'count(*)') > 0);

				if (($subscribed === true)) {
					$video_data->is_subscribed = 1;
				}
			}


			$video_title       = PT_Secure($video_data->title);

			$sql_query         = "
				SELECT * FROM `$t_videos` 
				WHERE MATCH (title) 
				AGAINST ('$video_title') 
				AND id <> '{$video_data->id}' 
				ORDER BY `id` DESC 
				LIMIT 20";

			$related_videos = $db->rawQuery($sql_query);

			foreach ($related_videos as $related_video) {
				$related_video         = PT_GetVideoByID($related_video, 0, 1, 0);
				$user_data             = PT_UserData($related_video->user_id);
				$related_video->owner  = array_intersect_key(
					ToArray($user_data), 
					array_flip($user_public_data)
				);

				$video_data->suggested_videos[] = $related_video;
			}

			$video_data->video_ad = array();
			if ((($pt->config->usr_v_mon == 'on' && $pt->config->user_mon_approve == 'off') || ($pt->config->usr_v_mon == 'on' && $pt->config->user_mon_approve == 'on' && $pt->user->monetization == '1')) && $video_data->monetization == 1 && $pt->user->video_mon == 1) {


				$user_ads      = pt_get_user_ads();
		        if (!empty($user_ads)) {  
		            $get_random_ad =  $user_ads;
		            $random_ad_id  = $get_random_ad->id;
		            $user_ads->url       = urldecode($get_random_ad->url);
		            $user_ads->domain       = pt_url_domain(urldecode($user_ads->url));
		            $user_ads->media      = PT_GetMedia($get_random_ad->media);
		            $user_ads->time_text      = PT_Time_Elapsed_String($user_ads->posted);;
		            
		            if ($user_ads->type == 1) {
		                $user_ad_trans   = "rad-transaction";
		                $_SESSION['ua_'] = $random_ad_id;
		                $_SESSION['vo_'] = $video_data->user_id;
		            }

		            else{
		                pt_register_ad_views($random_ad_id,$video_data->user_id); 
		                $db->insert(T_ADS_TRANS,array('type' => 'view', 'ad_id' => $random_ad_id, 'video_owner' => $video_data->user_id, 'time' => time()));
		            }
		            if ($user_ads->category == 'image') {
		            	$user_ads->redirect_link = PT_Link('redirect/' . $get_random_ad->id . '?type=image');
		            }
		            else{
		            	$user_ads->redirect_link = PT_Link('redirect/' . $get_random_ad->id . '?type=video');
		            }

		            if ($user_ads->type == 1) {
		            	$user_ads->ad_type = 'click';
		            }
		            else{
		            	$user_ads->ad_type = 'views';
		            	$update_clicks = $db->where('id', $get_random_ad->id)->update(T_VIDEO_ADS, array(
			                'views' => $db->inc(1)
			            ));
		            }
		            
		            
		            $video_data->video_ad = $user_ads;
		        }
			}
			
			$response_data     = array(
		        'api_status'   => '200',
		        'api_version'  => $api_version,
		        'data'         => $video_data
		    );

		    $update = array('views' => ($video_data->views += 1));
		    $db->where('video_id',$video_id)->update($t_videos,$update);
		}

		else{

			$response_data       = array(
		        'api_status'     => '500',
		        'api_version'    => $api_version,
		        'errors'         => array(
		            'error_id'   => '3',
		            'error_text' => 'Error: an unknown error occurred. Please try again later'
		        )
		    );
		}
	}
}